/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma;

import java.lang.reflect.Array;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.magmafoundation.magma.betterui.BetterUI;
import org.magmafoundation.magma.common.MagmaConstants;
import org.magmafoundation.magma.common.utils.JarTool;
import org.magmafoundation.magma.common.utils.SystemType;
import org.magmafoundation.magma.installer.MagmaInstaller;
import org.magmafoundation.magma.updater.MagmaUpdater;
import org.magmafoundation.magma.utils.BootstrapLauncher;
import org.magmafoundation.magma.utils.ServerInitHelper;

public class MagmaStart {
    private static String[] args;
    public static boolean postInstall;

    public static void main(String[] args) throws Exception {
        MagmaStart.args = args;
        if (MagmaStart.containsArg("-noui")) {
            BetterUI.setEnabled(false);
        }
        if (MagmaStart.containsArg("-nologo")) {
            BetterUI.setEnableBigLogo(false);
        }
        if (MagmaStart.containsArg("-postinstall")) {
            postInstall = true;
        }
        Path eula = Paths.get("eula.txt", new String[0]);
        if (MagmaStart.containsArg("-accepteula")) {
            BetterUI.forceAcceptEULA(eula);
        }
        boolean enableUpdate = !MagmaStart.containsArg("-dau");
        MagmaStart.containsArg("-nojline");
        if (!postInstall) {
            BetterUI.printTitle("Magma", "MagmaFoundation", System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")", MagmaConstants.VERSION, "v1_18_R2", MagmaConstants.FORGE_VERSION);
            System.err.println("WARNING: The new server jar is still under development and will be unstable! If you experience any issues, please report them to the developers.");
            System.err.println("WARNING: If the server crashes while installing, try removing the libraries folder and launching the server again.");
        }
        if (!BetterUI.checkEula(eula)) {
            System.exit(0);
        }
        List<String> launchArgs = JarTool.readFileLinesFromJar("data/" + (SystemType.getOS().equals((Object)SystemType.OS.WINDOWS) ? "win" : "unix") + "_args.txt");
        ArrayList forgeArgs = new ArrayList();
        launchArgs.stream().filter(s -> s.startsWith("--launchTarget") || s.startsWith("--fml.forgeVersion") || s.startsWith("--fml.mcVersion") || s.startsWith("--fml.forgeGroup") || s.startsWith("--fml.mcpVersion")).toList().forEach(arg -> {
            forgeArgs.add(arg.split(" ")[0]);
            forgeArgs.add(arg.split(" ")[1]);
        });
        new MagmaInstaller(Arrays.stream(args).toList());
        ServerInitHelper.init(launchArgs);
        if (enableUpdate) {
            MagmaUpdater.checkForUpdates();
        }
        String[] invokeArgs = (String[])Stream.concat(forgeArgs.stream(), Stream.of(MagmaStart.args)).toArray(String[]::new);
        BootstrapLauncher.startServer(invokeArgs);
    }

    private static boolean containsArg(String arg) {
        if (Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase(arg))) {
            args = MagmaStart.remove(args, arg);
            return true;
        }
        return false;
    }

    private static String[] remove(String[] array, String element) {
        if (array.length > 0) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equalsIgnoreCase(element)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                String[] copy = (String[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
                if (copy.length > 0) {
                    System.arraycopy(array, 0, copy, 0, index);
                    System.arraycopy(array, index + 1, copy, index, copy.length - index);
                }
                return copy;
            }
        }
        return array;
    }

    static {
        postInstall = false;
    }
}

